/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.das2.DasNameException;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.util.LoggerManager;

public class ColumnController
extends DomNodeController {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom");
    Column column;
    DasColumn dasColumn;
    Canvas canvas;
    ApplicationController applicationController;
    PropertyChangeListener nameListener;
    PropertyChangeListener dasColumnPosListener;
    PropertyChangeListener columnPosListener;

    ColumnController(ApplicationController applicationController, Column column) {
        super(column);
        this.column = column;
        this.applicationController = applicationController;
        column.controller = this;
        this.createNameListener();
        column.addPropertyChangeListener("parent", this.nameListener);
    }

    void createNameListener() {
        this.nameListener = evt -> {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
            if (evt.getPropertyName().equals("parent")) {
                String newid = (String)evt.getNewValue();
                this.doSetParentColumn((String)evt.getOldValue(), newid);
            }
        };
    }

    private void doSetParentColumn(String old, String newid) {
        if (newid.isEmpty()) {
            return;
        }
        DomNode n = this.applicationController.getElementById(newid);
        if (n == null) {
            throw new IllegalArgumentException("unable to find parent with id: " + newid);
        }
        if (!(n instanceof Column)) {
            if (old == null) {
                throw new IllegalArgumentException("unable to find Column for id: " + newid);
            }
            this.column.setParent(old);
        }
        Column newcolumn = (Column)n;
        this.column.controller.dasColumn.setParentColumn(newcolumn.getController().getDasColumn());
    }

    PropertyChangeListener createDasColumnPosListener(final List<String> minList, final List<String> maxList) {
        this.dasColumnPosListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                if (maxList.contains(evt.getPropertyName())) {
                    ColumnController.this.column.setRight(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)false));
                } else if (minList.contains(evt.getPropertyName())) {
                    ColumnController.this.column.setLeft(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)true));
                }
            }
        };
        return this.dasColumnPosListener;
    }

    PropertyChangeListener createColomnPosListener() {
        this.columnPosListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)((String)evt.getNewValue()));
                    if (evt.getPropertyName().equals("left")) {
                        ColumnController.this.dasColumn.setMin(dd[0], dd[1], (int)dd[2]);
                    } else if (evt.getPropertyName().equals("right")) {
                        ColumnController.this.dasColumn.setMax(dd[0], dd[1], (int)dd[2]);
                    }
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, "parse exception: {0}", ex);
                    ColumnController.this.column.setLeft(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)true));
                    ColumnController.this.column.setRight(DasDevicePosition.formatLayoutStr((DasDevicePosition)ColumnController.this.dasColumn, (boolean)false));
                }
            }
        };
        return this.columnPosListener;
    }

    protected void createDasPeer(Canvas canvas, DasColumn parent) {
        DasCanvas c = canvas.controller.getDasCanvas();
        this.dasColumn = DasColumn.create((DasCanvas)c, (DasColumn)parent, (String)this.column.getLeft(), (String)this.column.getRight());
        try {
            if (this.column.getId().length() > 0) {
                this.dasColumn.setDasName(this.column.getId());
            }
        }
        catch (DasNameException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.applicationController.bind(this.column, "left", this.dasColumn, "minLayout");
        this.applicationController.bind(this.column, "right", this.dasColumn, "maxLayout");
        this.doSetParentColumn(null, this.column.getParent());
        this.canvas = canvas;
    }

    public boolean isLayoutEqual(String spec) throws ParseException {
        String[] ss = spec.split(",");
        String s1 = DasDevicePosition.formatFormatStr((double[])DasDevicePosition.parseLayoutStr((String)ss[0]));
        if (!this.column.left.equals(s1)) {
            return false;
        }
        s1 = DasDevicePosition.formatFormatStr((double[])DasDevicePosition.parseLayoutStr((String)ss[1]));
        return this.column.right.equals(s1);
    }

    public void removeBindings() {
        this.applicationController.unbind(this.column);
        this.column.removePropertyChangeListener("parent", this.nameListener);
    }

    public void removeReferences() {
    }

    public DasColumn getDasColumn() {
        return this.dasColumn;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

